import os
import requests
from dotenv import load_dotenv

load_dotenv()

BOT_TOKEN = os.environ.get("BOT_TOKEN")
BASE_URL = os.environ.get("BASE_URL", "").rstrip("/")
WEBHOOK_PATH = os.environ.get("WEBHOOK_PATH", "/tg/webhook")
WEBHOOK_SECRET = os.environ.get("WEBHOOK_SECRET", "")

if not BOT_TOKEN:
    raise SystemExit("BOT_TOKEN not set")

api = f"https://api.telegram.org/bot{BOT_TOKEN}"
webhook_url = f"{BASE_URL}{WEBHOOK_PATH}"

payload = {"url": webhook_url}
if WEBHOOK_SECRET:
    payload["secret_token"] = WEBHOOK_SECRET

r = requests.post(f"{api}/setWebhook", data=payload, timeout=30)
print("Status:", r.status_code)
print(r.text)
